function [p_0,p_comb,p_comb_full,...
    sigma_C,sigma_C_full,...
    sigma_norm_0,sigma_norm,sigma_norm_comb,...
    sigma_norm_eff_0,sigma_norm_eff,sigma_norm_eff_comb,...
    sigma_norm_eff_full,sigma_norm_eff_full_comb,...
    sigma_shear_0,sigma_shear,sigma_shear_comb,...
    sigma_slip,sigma_slip_full,y] = ...
    fault_slip_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,eta_reg,flag_fric,flag_reg,g,...
    kappa,K_eff,mu_dyn,mu_st,n_pt_y,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,...
    y_delta,y_max,y_min)
%
% Computes stresses at the fault for vertical coordinate y. Vectorized. 
%

% Compute auxiliary variables:
C = ((1-2*nu)*alpha*p_inc) / (2*pi*(1-nu)); % scaling parameter, N/m^2
if y_max == y_min % input given as scalar or vector
    y = y_max; 
else % input given as minimum and maximum values
    y = linspace(y_min,y_max,n_pt_y); 
end

% Compute gradient:
p_0 = p_0_center - rho_f * g * y; % p_0_center is the initial pressure @ y=0
% p_0 = p_0_center; % !!! constant p_0

% Compute initial stresses:
if sigma_v_0 == 0 % compute sigma_v_0 from overburden weigth
    sigma_v_0 = ( (1-phi)*rho_s + phi*rho_f ) * g * (y-D_center); % initial vertical stress
%    sigma_v_0 = ( (1-phi)*rho_s + phi*rho_f ) * g * (-D_center); % !!! const. init. vert. str.
end
sigma_v_eff_0 = sigma_v_0 + alpha * p_0; % initial effective vertical stress
sigma_h_eff_0 = K_eff * sigma_v_eff_0; % initial effective horizontal stress
sigma_h_0 = sigma_h_eff_0 - alpha * p_0; % initial horizontal stress
sigma_norm_0  = sigma_h_0 * (sin(theta))^2 + sigma_v_0 * (cos(theta))^2; % initial normal str.
sigma_shear_0 = - (sigma_v_0 - sigma_h_0) * sin(theta) * cos(theta); % initial shear stress

% Compute incremental stresses:
if flag_reg == 1 % regularized expressions
    e = eta_reg;
    sigma_xx = -C * ( atan2( ((a+b)*e),(e^2+(y-b).*(y+a)) ) + ...
                      atan2( ((a+b)*e),(e^2+(y-a).*(y+b)) ) );
    sigma_xy = (C/2) * log( ( (e^2+(y-a).^2).*(e^2+(y+a).^2) ) ./ ...
                            ( (e^2+(y-b).^2).*(e^2+(y+b).^2) ) );
else % non-regularized expressions (containing discontinuities and singularities)
    sigma_xx = ...
         0      * ( (y <= -b) + (b <= y) ) + ...
        -pi*C   * ( ( (-b < y) .* (y <= -a) ) + ( (a <= y) .* (y < b) ) ) + ...
        -2*pi*C * (-a < y) .* (y < a);
    sigma_xy = (C/2) * log( ((y-a).^2.*(y+a).^2)./((y-b).^2.*(y+b).^2) );
end
sigma_norm =  (-sigma_xy * sin(theta)*cos(theta) + sigma_xx * sin(theta)^2 ); 
sigma_shear = ( sigma_xy * sin(theta)^2 + sigma_xx * sin(theta)*cos(theta) ); 

% Compute effective stresses:
sigma_norm_eff_0 = sigma_norm_0 + alpha*p_0; % effective initial normal stress
if flag_reg == 1 % regularized expressions
    shift = alpha*p_inc/pi * atan2((a+b)*e,e^2+(y-b).*(y+b)); 
    sigma_norm_eff = sigma_norm + shift; % regularized effective incremental normal stress; ...
    % only fault in reservoir "sees" incremental pressure
else
    sigma_norm_eff = sigma_norm + alpha*p_inc * (-b < y) .* (y < b); % effective ...
    % incremental normal stress; only fault in reservoir "sees" incremental pressure
end
sigma_norm_eff_full = sigma_norm + alpha*p_inc; % effective incremental normal stress; ...
% full fault "sees" incremental pressure

% Compute combined quantities:
p_comb = p_0 + p_inc * (-b < y) .* (y < b); % combined initial and reservoir-only incr. pr.;
p_comb_full = p_0 + p_inc; % combined initial and full-fault incremental pressures
sigma_norm_comb = sigma_norm_0 + sigma_norm; % combined initial and incremental normal stresses 
sigma_norm_eff_comb = sigma_norm_eff_0 + sigma_norm_eff; % combined initial and incremental
% effective normal stresses; reservoir-only incremental pressure
sigma_norm_eff_full_comb = sigma_norm_eff_0 + sigma_norm_eff_full; % combined initial and
% incremental effective normal stresses; full-fault incremental pressure
sigma_shear_comb = sigma_shear_0 + sigma_shear;  % combined initial and incremental shear str.

% % % % % Compute right-hand slip boundary and Coulomb stresses:
% % % % sigma_slip = kappa-mu_st*sigma_norm_eff_comb; % slip boundary; reservoir-only incremental pr.
% % % % sigma_slip_full = kappa-mu_st*sigma_norm_eff_full_comb; % slip boundary; full-fault incr. pr.
% % % % sigma_C = sigma_shear_comb - sigma_slip; % Coulomb stress; reservoir-only incremental pressure
% % % % sigma_C_full = sigma_shear_comb - sigma_slip_full; % Coulomb stress; full-fault incremental pr.

% Compute right-hand slip boundary and Coulomb stresses:
switch flag_fric
    case 0 % no friction
        sigma_slip = 0; % slip boundary; reservoir-only incremental pressure
        sigma_slip_full = 0; % slip boundary; full-fault incremental pressure
    case 1 % static friction only
        sigma_slip = kappa-mu_st*sigma_norm_eff_comb; % slip boundary; reservoir-only incr. pr.
        sigma_slip_full = kappa-mu_st*sigma_norm_eff_full_comb; % sl. b.; full-fault incr. pr.
    case 2 % slip-dependent friction
        delta_fric = interp1(y_delta,delta,y,'linear',0);
        df = abs(delta_fric);
        if flag_reg == 1 && eps_reg ~= 0 % regularized expressions
            a1 = mu_st;
            b1 = 0;
            c1 = (mu_st-mu_dyn)/(2*eps_reg^2-2*delta_c*eps_reg);
            a2 = (eps_reg*(mu_st+mu_dyn)-2*delta_c*mu_st)/(2*eps_reg-2*delta_c);
            b2 = (mu_st-mu_dyn)/(eps_reg-delta_c);
            a3 = (delta_c^2*(mu_dyn-mu_st)+2*eps_reg^2*mu_dyn-2*delta_c*eps_reg*mu_dyn)/...
                (2*eps_reg^2-2*delta_c*eps_reg);
            b3 = (delta_c*(mu_st-mu_dyn))/(eps_reg^2-delta_c*eps_reg);
            c3 = -(mu_st-mu_dyn)/(2*eps_reg^2-2*delta_c*eps_reg);
            mu = (a1+b1*df+c1*df.^2) .* (df < eps_reg) + ...
                 (a2+b2*df)          .* (eps_reg <= df) .* (df < delta_c-eps_reg) + ...
                 (a3+b3*df+c3*df.^2) .* (delta_c-eps_reg <= df) .* (df < delta_c) + ...
                 mu_dyn              .* (delta_c <= df);
        else
            mu_help = mu_st - (mu_st - mu_dyn) * df/delta_c;
            mu = min(max(mu_help,mu_dyn),mu_st); % ensures that mu_dyn < mu < mu_st
         end
        sigma_slip = kappa-mu.*sigma_norm_eff_comb; % slip boundary; reservoir-only incr. pr.
        sigma_slip_full = kappa-mu.*sigma_norm_eff_full_comb; % sl. b.; full-fault incr. pr.
end
sigma_C = sigma_shear_comb - sigma_slip; % Coulomb stress; reservoir-only incremental pressure
sigma_C_full = sigma_shear_comb - sigma_slip_full; % Coulomb stress; full-fault incremental pr.


